class GlobalCharge {
  String? id;
  String? slug;
  String? fixedCharge;
  String? percentCharge;
  String? minLimit;
  String? maxLimit;
  String? agentCommissionFixed;
  String? agentCommissionPercent;
  String? merchantPaymentFixedCharge;
  String? merchantPaymentPercentCharge;
  String? userPaymentPercentCharge;
  String? userPaymentFixedCharge;
  String? monthlyLimit;
  String? dailyLimit;
  String? dailyRequestAcceptLimit;
  String? monthlyRequestAcceptLimit;
  String? cap;
  String? voucherLimit;
  String? createdAt;
  String? updatedAt;

  GlobalCharge({
    this.id,
    this.slug,
    this.fixedCharge,
    this.percentCharge,
    this.minLimit,
    this.maxLimit,
    this.agentCommissionFixed,
    this.agentCommissionPercent,
    this.merchantPaymentFixedCharge,
    this.merchantPaymentPercentCharge,
    this.userPaymentPercentCharge,
    this.userPaymentFixedCharge,
    this.monthlyLimit,
    this.dailyLimit,
    this.dailyRequestAcceptLimit,
    this.monthlyRequestAcceptLimit,
    this.cap,
    this.voucherLimit,
    this.createdAt,
    this.updatedAt,
  });

  factory GlobalCharge.fromJson(Map<String, dynamic> json) => GlobalCharge(
        id: json["id"]?.toString(),
        slug: json["slug"]?.toString(),
        fixedCharge: json["fixed_charge"]?.toString(),
        percentCharge: json["percent_charge"]?.toString(),
        minLimit: json["min_limit"]?.toString(),
        maxLimit: json["max_limit"]?.toString(),
        agentCommissionFixed: json["agent_commission_fixed"]?.toString(),
        agentCommissionPercent: json["agent_commission_percent"]?.toString(),
        merchantPaymentFixedCharge: json["merchant_payment_fixed_charge"]?.toString(),
        merchantPaymentPercentCharge: json["merchant_payment_percent_charge"]?.toString(),
        userPaymentPercentCharge: json["user_payment_percent_charge"]?.toString(),
        userPaymentFixedCharge: json["user_payment_fixed_charge"]?.toString(),
        monthlyLimit: json["monthly_limit"]?.toString(),
        dailyLimit: json["daily_limit"]?.toString(),
        dailyRequestAcceptLimit: json["daily_request_accept_limit"]?.toString(),
        monthlyRequestAcceptLimit: json["monthly_request_accept_limit"]?.toString(),
        cap: json["cap"]?.toString(),
        voucherLimit: json["voucher_limit"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "slug": slug,
        "fixed_charge": fixedCharge,
        "percent_charge": percentCharge,
        "min_limit": minLimit,
        "max_limit": maxLimit,
        "agent_commission_fixed": agentCommissionFixed,
        "agent_commission_percent": agentCommissionPercent,
        "merchant_payment_fixed_charge": merchantPaymentFixedCharge,
        "merchant_payment_percent_charge": merchantPaymentPercentCharge,
        "user_payment_percent_charge": userPaymentPercentCharge,
        "user_payment_fixed_charge": userPaymentFixedCharge,
        "monthly_limit": monthlyLimit,
        "daily_limit": dailyLimit,
        "daily_request_accept_limit": dailyRequestAcceptLimit,
        "monthly_request_accept_limit": monthlyRequestAcceptLimit,
        "cap": cap,
        "voucher_limit": voucherLimit,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
